/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.CasinoRules;
import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Situation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0014\u0010\u001f\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0014\u0010!\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0014\u0010#\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/panopset/blackjackEngine/StrategyAction;", "", "situation", "Lcom/panopset/blackjackEngine/Situation;", "casinoRules", "Lcom/panopset/blackjackEngine/CasinoRules;", "<init>", "(Lcom/panopset/blackjackEngine/Situation;Lcom/panopset/blackjackEngine/CasinoRules;)V", "hand", "Lcom/panopset/blackjackEngine/HandPlayer;", "canDouble", "", "singleDeck", "getRecommendedAction", "", "recommendedActionText", "hstarRecommendation", "getHstarRecommendation", "()Ljava/lang/String;", "hxRecommendation", "getHxRecommendation", "hatRecommenation", "getHatRecommenation", "htRecommendation", "getHtRecommendation", "rsRecommendation", "getRsRecommendation", "rhRecommendation", "getRhRecommendation", "shRecommendation", "getShRecommendation", "hdRecommendation", "getHdRecommendation", "dsRecommendation", "getDsRecommendation", "dhRecommendation", "getDhRecommendation", "blackjackEngine"})
public final class StrategyAction {
    @NotNull
    private final CasinoRules casinoRules;
    @Nullable
    private final HandPlayer hand;
    private final boolean canDouble;
    private final boolean singleDeck;

    public StrategyAction(@NotNull Situation situation, @NotNull CasinoRules casinoRules) {
        Intrinsics.checkNotNullParameter(situation, "situation");
        Intrinsics.checkNotNullParameter(casinoRules, "casinoRules");
        this.casinoRules = casinoRules;
        HandPlayer handPlayer = this.hand = situation.getHandPlayer();
        this.canDouble = handPlayer != null ? handPlayer.canDouble(this.casinoRules.isDoubleAfterSplitAllowed()) : false;
        this.singleDeck = this.casinoRules.getDecks() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getRecommendedAction(@Nullable String recommendedActionText) {
        String string = recommendedActionText;
        if (string == null) return "s";
        int n = -1;
        switch (string.hashCode()) {
            case 80: {
                if (string.equals("P")) {
                    n = 1;
                }
                break;
            }
            case 2352: {
                if (string.equals("Hx")) {
                    n = 2;
                }
                break;
            }
            case 2657: {
                if (string.equals("Rs")) {
                    n = 3;
                }
                break;
            }
            case 2274: {
                if (string.equals("H*")) {
                    n = 4;
                }
                break;
            }
            case 2212: {
                if (string.equals("Dh")) {
                    n = 5;
                }
                break;
            }
            case 2677: {
                if (string.equals("Sh")) {
                    n = 6;
                }
                break;
            }
            case 2646: {
                if (string.equals("Rh")) {
                    n = 7;
                }
                break;
            }
            case 72: {
                if (string.equals("H")) {
                    n = 8;
                }
                break;
            }
            case 2296: {
                if (string.equals("H@")) {
                    n = 9;
                }
                break;
            }
            case 2332: {
                if (string.equals("Hd")) {
                    n = 10;
                }
                break;
            }
            case 2316: {
                if (string.equals("HT")) {
                    n = 11;
                }
                break;
            }
            case 2223: {
                if (string.equals("Ds")) {
                    n = 12;
                }
                break;
            }
        }
        switch (n) {
            case 8: {
                return "h";
            }
            case 1: {
                return "p";
            }
            case 4: {
                String string2 = this.getHstarRecommendation();
                return string2;
            }
            case 2: {
                String string2 = this.getHxRecommendation();
                return string2;
            }
            case 10: {
                String string2 = this.getHdRecommendation();
                return string2;
            }
            case 9: {
                String string2 = this.getHatRecommenation();
                return string2;
            }
            case 11: {
                String string2 = this.getHtRecommendation();
                return string2;
            }
            case 3: {
                String string2 = this.getRsRecommendation();
                return string2;
            }
            case 7: {
                String string2 = this.getRhRecommendation();
                return string2;
            }
            case 6: {
                String string2 = this.getShRecommendation();
                return string2;
            }
            case 5: {
                String string2 = this.getDhRecommendation();
                return string2;
            }
            case 12: {
                String string2 = this.getDsRecommendation();
                return string2;
            }
            default: {
                return "s";
            }
        }
    }

    private final String getHstarRecommendation() {
        return this.singleDeck ? this.getDhRecommendation() : "h";
    }

    private final String getHxRecommendation() {
        return this.singleDeck ? this.getDsRecommendation() : "h";
    }

    private final String getHatRecommenation() {
        return this.singleDeck ? "p" : "h";
    }

    private final String getHtRecommendation() {
        if (this.hand == null) {
            return "s";
        }
        if (this.hand.isInitialDeal()) {
            for (BlackjackCard card : this.hand.getBlackjackCards()) {
                if (card.getHardValue() != 10) continue;
                return "h";
            }
        }
        return "s";
    }

    private final String getRsRecommendation() {
        return this.casinoRules.isLateSurrenderAllowed() ? "u" : "s";
    }

    private final String getRhRecommendation() {
        return this.casinoRules.isLateSurrenderAllowed() ? "u" : "h";
    }

    private final String getShRecommendation() {
        if (this.hand == null) {
            return "s";
        }
        for (BlackjackCard card : this.hand.getBlackjackCards()) {
            if (card.getHardValue() != 4 && card.getHardValue() != 5) continue;
            return "s";
        }
        return "h";
    }

    private final String getHdRecommendation() {
        return this.canDouble && (this.casinoRules.getDealerHitsSoft17() || this.casinoRules.getDecks() < 3) ? "d" : "h";
    }

    private final String getDsRecommendation() {
        return this.canDouble ? "d" : "s";
    }

    private final String getDhRecommendation() {
        return this.canDouble ? "d" : "h";
    }
}

