/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.BetAmountStrategy;
import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.BlackjackGameEngine;
import com.panopset.blackjackEngine.BlackjackMessages;
import com.panopset.blackjackEngine.BlackjackShoe;
import com.panopset.blackjackEngine.CountingSystems;
import com.panopset.blackjackEngine.HandDealer;
import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Player;
import com.panopset.blackjackEngine.Settlement;
import com.panopset.blackjackEngine.Situation;
import com.panopset.blackjackEngine.Strategy;
import com.panopset.blackjackEngine.StrategyLine;
import com.panopset.blackjackEngine.Wager;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010,J\u0006\u0010-\u001a\u00020\u001fJ\b\u0010.\u001a\u00020\u001fH\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u001aH\u0002J\b\u00100\u001a\u0004\u0018\u00010,J\u0006\u00101\u001a\u00020\u001fJ\b\u00102\u001a\u00020\u001fH\u0002J\b\u00103\u001a\u00020\u001fH\u0002J\b\u00104\u001a\u00020\u001fH\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001aH\u0002J\b\u00108\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001e\u0010:\u001a\u0002062\u0006\u00109\u001a\u000206@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001e\u0010<\u001a\u0002062\u0006\u00109\u001a\u000206@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010;\u00a8\u0006="}, d2={"Lcom/panopset/blackjackEngine/Cycle;", "", "bge", "Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "strategy", "Lcom/panopset/blackjackEngine/Strategy;", "<init>", "(Lcom/panopset/blackjackEngine/BlackjackGameEngine;Lcom/panopset/blackjackEngine/Strategy;)V", "getBge", "()Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "getStrategy", "()Lcom/panopset/blackjackEngine/Strategy;", "blackjackConfiguration", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "countingSystems", "Lcom/panopset/blackjackEngine/CountingSystems;", "dealer", "Lcom/panopset/blackjackEngine/HandDealer;", "getDealer", "()Lcom/panopset/blackjackEngine/HandDealer;", "msg", "Lcom/panopset/blackjackEngine/BlackjackMessages;", "getMsg", "()Lcom/panopset/blackjackEngine/BlackjackMessages;", "players", "Ljava/util/ArrayList;", "Lcom/panopset/blackjackEngine/Player;", "Lkotlin/collections/ArrayList;", "getPlayers", "()Ljava/util/ArrayList;", "placeBets", "", "toString", "", "getActivePlayer", "getRecommendedAction", "getStrategyLine", "Lcom/panopset/blackjackEngine/StrategyLine;", "activeSituation", "Lcom/panopset/blackjackEngine/Situation;", "getActiveSituation", "()Lcom/panopset/blackjackEngine/Situation;", "getCurrentSituation", "hand", "Lcom/panopset/blackjackEngine/HandPlayer;", "deal", "checkFor21", "player", "getActivePlayerHand", "finish", "completeCycle", "prepareSettlement", "resolvePlayerBlackjacks", "resolvePlayerHandsBlackjacks", "", "handPlayer", "collectAndPayChips", "value", "isDealt", "()Z", "isActive", "blackjackEngine"})
public final class Cycle {
    @NotNull
    private final BlackjackGameEngine bge;
    @NotNull
    private final Strategy strategy;
    @NotNull
    private final BlackjackConfiguration blackjackConfiguration;
    @NotNull
    private final CountingSystems countingSystems;
    @NotNull
    private final HandDealer dealer;
    @NotNull
    private final BlackjackMessages msg;
    @NotNull
    private final ArrayList<Player> players;
    private boolean isDealt;
    private boolean isActive;

    public Cycle(@NotNull BlackjackGameEngine bge, @NotNull Strategy strategy) {
        Intrinsics.checkNotNullParameter(bge, "bge");
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        this.bge = bge;
        this.strategy = strategy;
        this.blackjackConfiguration = this.bge.getConfig();
        this.countingSystems = this.bge.getCountingSystems();
        this.dealer = new HandDealer();
        this.msg = this.bge.getConfig().getMessages();
        this.players = new ArrayList();
    }

    @NotNull
    public final BlackjackGameEngine getBge() {
        return this.bge;
    }

    @NotNull
    public final Strategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final HandDealer getDealer() {
        return this.dealer;
    }

    @NotNull
    public final BlackjackMessages getMsg() {
        return this.msg;
    }

    @NotNull
    public final ArrayList<Player> getPlayers() {
        return this.players;
    }

    public final void placeBets() {
        this.players.clear();
        int n = this.blackjackConfiguration.getSeats();
        for (int i = 0; i < n; ++i) {
            if (this.bge.isCountVeryNegative()) {
                this.bge.triggerShuffleBeforeNextHand();
            }
            int betAmount = new BetAmountStrategy(this.bge).adjust();
            Player player = new Player(new Wager(this.bge.getBankroll().subtract(betAmount)));
            player.getHands().get(0).getWager().setInitialBet(betAmount);
            this.players.add(player);
        }
    }

    @NotNull
    public String toString() {
        StringWriter sw = new StringWriter();
        sw.append("Dealer: ");
        String string = "%s%n";
        Object[] objectArray = new Object[]{this.dealer.getCards()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        sw.append(string2);
        Iterator iterator2 = ((Iterable)this.players).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Player p = (Player)iterator2.next();
            String string3 = "Player %d: %s%n";
            Object[] objectArray2 = new Object[]{i, p.toString()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            sw.append(string4);
        }
        sw.append(" Bankroll:" + this.bge.getBankroll());
        String string5 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
        return string5;
    }

    @Nullable
    public final Player getActivePlayer() {
        Iterator<Player> iterator2 = this.players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Player p;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (p.isFinal()) continue;
            return p;
        }
        return null;
    }

    @NotNull
    public final String getRecommendedAction() {
        return this.dealer.isFinal() || !this.dealer.hasCards() ? "l" : this.strategy.getRecommendation(this.getCurrentSituation(this.getActivePlayerHand()));
    }

    @Nullable
    public final StrategyLine getStrategyLine() {
        StrategyLine strategyLine;
        if (this.getActivePlayer() == null) {
            strategyLine = null;
        } else {
            Player player = this.getActivePlayer();
            Intrinsics.checkNotNull(player);
            strategyLine = this.strategy.findStrategyLine(this.getCurrentSituation(player.getActiveHand()));
        }
        return strategyLine;
    }

    @NotNull
    public final Situation getActiveSituation() {
        return this.getCurrentSituation(this.getActivePlayerHand());
    }

    @NotNull
    public final Situation getCurrentSituation(@Nullable HandPlayer hand) {
        return this.isDealt ? new Situation(this.dealer.getUpCard(), hand) : new Situation(null, hand);
    }

    public final void deal() {
        Player p;
        this.placeBets();
        Iterator<Player> iterator2 = this.players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            HandPlayer handPlayer = p.getActiveHand();
            if (handPlayer != null) {
                handPlayer.dealCard(BlackjackShoe.INSTANCE.deal(true, this.countingSystems));
            }
            this.bge.reportNewHand();
        }
        this.dealer.dealCard(BlackjackShoe.INSTANCE.deal(false, this.countingSystems));
        Iterator<Player> iterator4 = this.players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            HandPlayer handPlayer = p.getActiveHand();
            if (handPlayer == null) continue;
            handPlayer.dealCard(BlackjackShoe.INSTANCE.deal(true, this.countingSystems));
        }
        this.dealer.dealCard(BlackjackShoe.INSTANCE.deal(true, this.countingSystems));
        this.checkFor21();
        this.isDealt = true;
        this.isActive = true;
    }

    private final void checkFor21() {
        Iterator<Player> iterator2 = this.players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Player player;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            this.checkFor21(player);
        }
        if (this.dealer.getHandValue() == 21) {
            this.finish();
        }
    }

    private final void checkFor21(Player player) {
        if (this.dealer.getUpCard().isAce() && this.bge.getConfig().isEvenMoneyOnBlackjackVace()) {
            Iterator<HandPlayer> iterator2 = player.getHands().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<HandPlayer> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                HandPlayer playerHand;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (!playerHand.isNatural21()) continue;
                playerHand.standWithEvenMoney();
            }
        } else {
            Iterator<HandPlayer> iterator4 = player.getHands().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
            Iterator<HandPlayer> iterator5 = iterator4;
            while (iterator5.hasNext()) {
                HandPlayer playerHand;
                Intrinsics.checkNotNullExpressionValue(iterator5.next(), "next(...)");
                if (playerHand.getHandValue() != 21) continue;
                HandPlayer handPlayer = player.getActiveHand();
                if (handPlayer == null) continue;
                handPlayer.stand();
            }
        }
    }

    @Nullable
    public final HandPlayer getActivePlayerHand() {
        Player player = this.getActivePlayer();
        if (player == null) {
            return null;
        }
        Player p = player;
        return p.getActiveHand();
    }

    public final void finish() {
        this.completeCycle();
        this.isActive = false;
    }

    private final void completeCycle() {
        if (!this.dealer.isFinal()) {
            this.prepareSettlement();
        }
    }

    private final void prepareSettlement() {
        BlackjackShoe.INSTANCE.show(this.dealer.getFirstCard(), this.countingSystems);
        this.resolvePlayerBlackjacks();
        while (!this.dealer.isFinal()) {
            if (this.dealer.getHandValue() < 17) {
                this.dealer.dealCard(this.bge.deal(true));
                continue;
            }
            if (this.dealer.getHandValue() == 17) {
                if (this.blackjackConfiguration.isDealerHitSoft17() && this.dealer.isSoft()) {
                    this.dealer.dealCard(this.bge.deal(true));
                    continue;
                }
                this.dealer.stand();
                continue;
            }
            this.dealer.stand();
        }
        this.bge.clearPriorHandBustedFlag();
        this.collectAndPayChips();
    }

    private final void resolvePlayerBlackjacks() {
        boolean allPlayersHaveBlackjack = true;
        Iterator<Player> iterator2 = this.players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Player handPlayer;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (this.resolvePlayerHandsBlackjacks(handPlayer)) continue;
            allPlayersHaveBlackjack = false;
        }
        if (allPlayersHaveBlackjack) {
            this.dealer.stand();
        }
    }

    private final boolean resolvePlayerHandsBlackjacks(Player handPlayer) {
        boolean allHandsAreBlackjack = true;
        Iterator<HandPlayer> iterator2 = handPlayer.getHands().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<HandPlayer> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            HandPlayer h;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (h.isBustedOrSurrenderred()) continue;
            if (this.dealer.isNatural21() && !this.blackjackConfiguration.isEuropeanStyle()) {
                h.stand();
                continue;
            }
            if (h.isNatural21()) {
                h.stand();
                continue;
            }
            allHandsAreBlackjack = false;
        }
        return allHandsAreBlackjack;
    }

    private final void collectAndPayChips() {
        Iterator<Player> iterator2 = this.players.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Player player;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            new Settlement(player, this.bge, this.msg).settlePlayer();
        }
        this.bge.getBankroll().settle(this.bge.getCycle().players);
    }

    public final boolean isDealt() {
        return this.isDealt;
    }

    public final boolean isActive() {
        return this.isActive;
    }
}

