/*
 * Decompiled with CFR 0.152.
 */
package com.panopset.blackjackEngine;

import com.panopset.blackjackEngine.Bankroll;
import com.panopset.blackjackEngine.BlackjackCard;
import com.panopset.blackjackEngine.BlackjackConfiguration;
import com.panopset.blackjackEngine.BlackjackGameState;
import com.panopset.blackjackEngine.BlackjackMessages;
import com.panopset.blackjackEngine.BlackjackShoe;
import com.panopset.blackjackEngine.CountingSystems;
import com.panopset.blackjackEngine.Cycle;
import com.panopset.blackjackEngine.CycleController;
import com.panopset.blackjackEngine.CycleSnapshot;
import com.panopset.blackjackEngine.HandPlayer;
import com.panopset.blackjackEngine.Metrics;
import com.panopset.blackjackEngine.Player;
import com.panopset.blackjackEngine.Strategy;
import com.panopset.blackjackEngine.StrategyLine;
import com.panopset.blackjackEngine.Wager;
import com.panopset.compat.LogDisplayer;
import com.panopset.compat.Logz;
import com.panopset.compat.LogzDisplayerCMD;
import com.panopset.compat.Stringop;
import com.panopset.compat.Zombie;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020*J\u0010\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020*H\u0002J\u0010\u00105\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u00106\u001a\u00020*H\u0002J\u0012\u00107\u001a\u00020*2\b\u00108\u001a\u0004\u0018\u000109H\u0002J\n\u0010:\u001a\u0004\u0018\u000109H\u0002J\u0010\u0010;\u001a\u0002032\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020>H\u0002J\u0012\u0010A\u001a\u0002032\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0018\u0010B\u001a\u0002032\u0006\u00108\u001a\u0002092\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010C\u001a\u0002032\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010D\u001a\u00020*2\u0006\u0010=\u001a\u00020>H\u0002J\"\u00105\u001a\u0002032\u0006\u00108\u001a\u0002092\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010E\u001a\u0002032\u0006\u0010+\u001a\u00020,2\u0006\u0010F\u001a\u00020,H\u0002J\u0018\u0010G\u001a\u00020*2\u0006\u0010H\u001a\u00020,2\u0006\u0010I\u001a\u00020,H\u0002J\u000e\u0010L\u001a\u00020*2\u0006\u0010M\u001a\u00020NJ\b\u0010R\u001a\u00020*H\u0002J\b\u0010S\u001a\u00020*H\u0002J\b\u0010T\u001a\u00020*H\u0002J\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u000203J\b\u0010X\u001a\u00020*H\u0002J\b\u0010Y\u001a\u00020*H\u0002J\b\u0010\\\u001a\u00020[H\u0002J\b\u0010^\u001a\u00020*H\u0002J\b\u0010_\u001a\u00020*H\u0002J\b\u0010`\u001a\u000203H\u0002J\u0006\u0010a\u001a\u00020*J\u0006\u0010e\u001a\u00020NJ\b\u0010f\u001a\u00020*H\u0002J\b\u0010r\u001a\u00020*H\u0002J\f\u0010s\u001a\b\u0012\u0004\u0012\u00020,0tJ\u0006\u0010u\u001a\u00020,J\f\u0010v\u001a\b\u0012\u0004\u0012\u00020,0tJ\u0006\u0010w\u001a\u00020,J\u0006\u0010x\u001a\u00020,J\u0006\u0010y\u001a\u00020,J\u0006\u0010z\u001a\u00020*J\u0006\u0010|\u001a\u00020*J\u0006\u0010~\u001a\u00020*J\u0006\u0010\u007f\u001a\u00020*J\u0007\u0010\u0082\u0001\u001a\u00020*J\u0007\u0010\u0083\u0001\u001a\u00020*J\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001J\u0007\u0010\u0086\u0001\u001a\u00020*J\u0007\u0010\u0087\u0001\u001a\u00020*J\u0011\u0010\u0088\u0001\u001a\u00020*2\b\u0010\u0089\u0001\u001a\u00030\u0085\u0001J\u0007\u0010\u008a\u0001\u001a\u000203J\u0007\u0010\u008b\u0001\u001a\u000203J\b\u0010\u008c\u0001\u001a\u00030\u008d\u0001J\u0011\u0010\u008e\u0001\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010J\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0014\u0010O\u001a\u00020N8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u000e\u0010Z\u001a\u00020[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020,X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010c\u001a\u00020N8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010QR\u001a\u0010g\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u001a\u0010l\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010i\"\u0004\bn\u0010kR\u001a\u0010o\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010i\"\u0004\bq\u0010kR\u001e\u0010{\u001a\u0002032\u0006\u0010M\u001a\u000203@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010KR\u001e\u0010}\u001a\u0002032\u0006\u0010M\u001a\u000203@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010KR \u0010\u0080\u0001\u001a\u00020N2\u0006\u0010M\u001a\u00020N@BX\u0086\u000e\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010QR \u0010\u008f\u0001\u001a\u00030\u008d\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001\"\u0006\b\u0092\u0001\u0010\u0093\u0001\u00a8\u0006\u0094\u0001"}, d2={"Lcom/panopset/blackjackEngine/BlackjackGameEngine;", "", "logDisplayer", "Lcom/panopset/compat/LogDisplayer;", "config", "Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "<init>", "(Lcom/panopset/compat/LogDisplayer;Lcom/panopset/blackjackEngine/BlackjackConfiguration;)V", "(Lcom/panopset/blackjackEngine/BlackjackConfiguration;)V", "getConfig", "()Lcom/panopset/blackjackEngine/BlackjackConfiguration;", "getShoe", "Lcom/panopset/blackjackEngine/BlackjackShoe;", "metrics", "Lcom/panopset/blackjackEngine/Metrics;", "getMetrics", "()Lcom/panopset/blackjackEngine/Metrics;", "setMetrics", "(Lcom/panopset/blackjackEngine/Metrics;)V", "ct", "Lcom/panopset/blackjackEngine/CycleController;", "getCt", "()Lcom/panopset/blackjackEngine/CycleController;", "strategy", "Lcom/panopset/blackjackEngine/Strategy;", "getStrategy", "()Lcom/panopset/blackjackEngine/Strategy;", "setStrategy", "(Lcom/panopset/blackjackEngine/Strategy;)V", "countingSystems", "Lcom/panopset/blackjackEngine/CountingSystems;", "getCountingSystems", "()Lcom/panopset/blackjackEngine/CountingSystems;", "setCountingSystems", "(Lcom/panopset/blackjackEngine/CountingSystems;)V", "msg", "Lcom/panopset/blackjackEngine/BlackjackMessages;", "bankroll", "Lcom/panopset/blackjackEngine/Bankroll;", "getBankroll", "()Lcom/panopset/blackjackEngine/Bankroll;", "exec", "", "action", "", "frontEndPreInitCheck", "cloneState", "Lcom/panopset/blackjackEngine/BlackjackGameState;", "deal", "Lcom/panopset/blackjackEngine/BlackjackCard;", "isShowing", "", "reset", "performAction", "dealNextHand", "reasonThisGameExists", "player", "Lcom/panopset/blackjackEngine/Player;", "checkForFinish", "performAdminAction", "hit", "handPlayer", "Lcom/panopset/blackjackEngine/HandPlayer;", "stand", "hand", "surrender", "split", "dbl", "doubleDownWager", "isPossibleAction", "ra", "updateMessages", "recommendedActionHeader", "recommendedActionStrategyLine", "isShuffleNeeded", "()Z", "setNextBet", "value", "", "wagerIncrement", "getWagerIncrement", "()I", "increase", "decrease", "updateInactiveHands", "getCycle", "Lcom/panopset/blackjackEngine/Cycle;", "isAutomaticRunning", "auto", "stopAutomaticThread", "automatic", "Ljava/lang/Thread;", "createNewAutomaticThread", "automaticRunningName", "startAutomaticThread", "doAutomatic", "isReadyToRunAutomatically", "shuffle", "nextBet", "minBet", "getMinBet", "getNextBet", "resetNextBet", "mistakeMessage", "getMistakeMessage", "()Ljava/lang/String;", "setMistakeMessage", "(Ljava/lang/String;)V", "mistakeHeader", "getMistakeHeader", "setMistakeHeader", "dealerMessage", "getDealerMessage", "setDealerMessage", "clearMessages", "getGameStatusVertical", "", "getGameStatusHorizontal", "getStatusChipsVertical", "getStatusChipsHorizontal", "getGameStatus", "getRawStatusChips", "reportNewHand", "isShuffleFlagOn", "triggerShuffleBeforeNextHand", "isBustedPriorHand", "setPriorHandBustedFlag", "clearPriorHandBustedFlag", "streak", "getStreak", "incrementStreak", "resetStreak", "getTotalValue", "", "setAutomaticOnForTesting", "clearAutomaticForTesting", "waitMillis", "i", "isCountVeryNegative", "isCountVeryPositive", "getCurrentSnapshot", "Lcom/panopset/blackjackEngine/CycleSnapshot;", "getNewActionCycleSnapshot", "lastActionSnapshot", "getLastActionSnapshot", "()Lcom/panopset/blackjackEngine/CycleSnapshot;", "setLastActionSnapshot", "(Lcom/panopset/blackjackEngine/CycleSnapshot;)V", "blackjackEngine"})
@SourceDebugExtension(value={"SMAP\nBlackjackGameEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackjackGameEngine.kt\ncom/panopset/blackjackEngine/BlackjackGameEngine\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,574:1\n108#2:575\n80#2,22:576\n108#2:598\n80#2,22:599\n*S KotlinDebug\n*F\n+ 1 BlackjackGameEngine.kt\ncom/panopset/blackjackEngine/BlackjackGameEngine\n*L\n460#1:575\n460#1:576,22\n473#1:598\n473#1:599,22\n*E\n"})
public class BlackjackGameEngine {
    @NotNull
    private final LogDisplayer logDisplayer;
    @NotNull
    private final BlackjackConfiguration config;
    @NotNull
    private Metrics metrics;
    @NotNull
    private final CycleController ct;
    @NotNull
    private Strategy strategy;
    @NotNull
    private CountingSystems countingSystems;
    @NotNull
    private final BlackjackMessages msg;
    @NotNull
    private final Bankroll bankroll;
    @NotNull
    private Thread automatic;
    @NotNull
    private final String automaticRunningName;
    private int nextBet;
    @NotNull
    private String mistakeMessage;
    @NotNull
    private String mistakeHeader;
    @NotNull
    private String dealerMessage;
    private boolean isShuffleFlagOn;
    private boolean isBustedPriorHand;
    private int streak;
    @NotNull
    private CycleSnapshot lastActionSnapshot;

    public BlackjackGameEngine(@NotNull LogDisplayer logDisplayer, @NotNull BlackjackConfiguration config) {
        Intrinsics.checkNotNullParameter(logDisplayer, "logDisplayer");
        Intrinsics.checkNotNullParameter(config, "config");
        this.logDisplayer = logDisplayer;
        this.config = config;
        this.metrics = new Metrics();
        this.ct = new CycleController(this);
        this.strategy = new Strategy(this.config);
        this.countingSystems = new CountingSystems(this.config);
        this.msg = this.config.getMessages();
        this.bankroll = new Bankroll();
        this.automatic = this.createNewAutomaticThread();
        this.automaticRunningName = "PanAutomatic";
        this.mistakeMessage = "";
        this.mistakeHeader = "";
        this.dealerMessage = "";
        this.lastActionSnapshot = new CycleSnapshot(this.cloneState(""));
    }

    @NotNull
    public final BlackjackConfiguration getConfig() {
        return this.config;
    }

    public BlackjackGameEngine(@NotNull BlackjackConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this(LogzDisplayerCMD.INSTANCE, config);
    }

    @NotNull
    public final BlackjackShoe getShoe() {
        return BlackjackShoe.INSTANCE;
    }

    @NotNull
    public final Metrics getMetrics() {
        return this.metrics;
    }

    public final void setMetrics(@NotNull Metrics metrics) {
        Intrinsics.checkNotNullParameter(metrics, "<set-?>");
        this.metrics = metrics;
    }

    @NotNull
    public final CycleController getCt() {
        return this.ct;
    }

    @NotNull
    public final Strategy getStrategy() {
        return this.strategy;
    }

    public final void setStrategy(@NotNull Strategy strategy) {
        Intrinsics.checkNotNullParameter(strategy, "<set-?>");
        this.strategy = strategy;
    }

    @NotNull
    public final CountingSystems getCountingSystems() {
        return this.countingSystems;
    }

    public final void setCountingSystems(@NotNull CountingSystems countingSystems) {
        Intrinsics.checkNotNullParameter(countingSystems, "<set-?>");
        this.countingSystems = countingSystems;
    }

    @NotNull
    public final Bankroll getBankroll() {
        return this.bankroll;
    }

    public void exec(@NotNull String action) {
        Intrinsics.checkNotNullParameter(action, "action");
        Logz.INSTANCE.setLogzDsiplayer(this.logDisplayer);
        this.frontEndPreInitCheck();
        this.performAction(action);
        this.getNewActionCycleSnapshot(action);
    }

    public final void frontEndPreInitCheck() {
        if (this.bankroll.getReloadAmount() == 0) {
            this.reset();
        }
    }

    private final BlackjackGameState cloneState(String action) {
        List<Player> players = this.ct.clonePlayers();
        return new BlackjackGameState(this.bankroll.getChips(), this.bankroll.getReloadCount(), this.config.getReloadAmountInWholeDollars() * 100, action, this.ct.cloneDealer(), players, new Metrics(this.metrics), this.getNextBet(), this.mistakeHeader, this.mistakeMessage, this.dealerMessage, this.getGameStatusVertical(), this.getGameStatusHorizontal(), this.getStatusChipsVertical(), this.getStatusChipsHorizontal(), this.bankroll.getStakeIncludingHands(players));
    }

    @NotNull
    public final BlackjackCard deal(boolean isShowing) {
        return BlackjackShoe.INSTANCE.deal(isShowing, this.countingSystems);
    }

    private final void reset() {
        this.bankroll.setReloadAmount(this.config.getReloadAmountInWholeDollars() * 100);
        if (this.bankroll.getReloadAmount() < 0) {
            throw new RuntimeException();
        }
        this.metrics.reset();
        this.ct.reset();
        this.bankroll.reset();
        this.countingSystems.resetCount();
        BlackjackShoe.INSTANCE.setNumberOfDecks(this.config.getDecks());
        this.resetNextBet();
        BlackjackShoe.INSTANCE.shuffle();
        Logz.INSTANCE.clear();
    }

    private final void performAction(String action) {
        HandPlayer handPlayer;
        Player player;
        StrategyLine sl;
        if (this.performAdminAction(action)) {
            return;
        }
        String ra = this.getCycle().getRecommendedAction();
        if (!this.isPossibleAction(action, ra)) {
            return;
        }
        String recommendedActionHeader = "";
        String recommendedActionStrategyLine = "";
        if (!Intrinsics.areEqual(action, ra) && (sl = this.getCycle().getStrategyLine()) != null) {
            recommendedActionStrategyLine = sl.getSource();
            recommendedActionHeader = this.strategy.getHeaderFor(sl.getStratCat());
        }
        if (Intrinsics.areEqual("l", action)) {
            this.dealNextHand();
        }
        if ((player = this.checkForFinish()) != null && this.performAction(player, handPlayer = player.getActiveHand(), action)) {
            if (handPlayer != null) {
                handPlayer.setAction(action);
            }
            player = this.checkForFinish();
            this.updateMessages(recommendedActionHeader, recommendedActionStrategyLine);
        }
        this.reasonThisGameExists(player);
    }

    private final void dealNextHand() {
        if (this.isShuffleNeeded()) {
            this.shuffle();
            this.countingSystems.resetCount();
        }
        if (this.getCycle().isDealt()) {
            this.ct.reset();
        }
        this.getCycle().deal();
    }

    private final void reasonThisGameExists(Player player) {
        if (player == null && this.config.isFastDeal() && !this.isAutomaticRunning() && Intrinsics.areEqual("", this.mistakeMessage)) {
            this.exec("l");
        }
    }

    private final Player checkForFinish() {
        Player player = this.getCycle().getActivePlayer();
        if (player == null) {
            this.getCycle().finish();
        }
        return player;
    }

    private final boolean performAdminAction(String action) {
        boolean bl;
        this.clearMessages();
        switch (action) {
            case "r": {
                this.reset();
                this.dealerMessage = this.msg.getResetMsg();
                bl = true;
                break;
            }
            case "c": {
                this.config.toggleShowCount();
                bl = true;
                break;
            }
            case "f": {
                if (this.ct.isActive()) {
                    String string = "%s.";
                    Object[] objectArray = new Object[]{this.msg.getHandActiveMsg()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    this.dealerMessage = string2;
                    return true;
                }
                this.shuffle();
                bl = true;
                break;
            }
            case "i": {
                this.increase();
                bl = true;
                break;
            }
            case "k": {
                this.decrease();
                bl = true;
                break;
            }
            case "t": {
                this.auto();
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final void hit(HandPlayer handPlayer) {
        handPlayer.dealCard(BlackjackShoe.INSTANCE.deal(true, this.countingSystems));
        if (handPlayer.isBusted()) {
            handPlayer.setMessage(this.msg.getBustedMsg());
            handPlayer.getWager().lost();
        }
    }

    private final void stand(HandPlayer hand) {
        hand.stand();
    }

    private final boolean surrender(HandPlayer handPlayer) {
        block2: {
            if (!this.config.isLateSurrenderAllowed()) {
                this.dealerMessage = this.msg.getSurrenderNotAllowedMsg();
                return false;
            }
            if (handPlayer != null && !handPlayer.isInitialDeal()) {
                this.dealerMessage = this.msg.getSurrenderImpossibleMsg();
                return false;
            }
            HandPlayer handPlayer2 = handPlayer;
            if (handPlayer2 == null) break block2;
            handPlayer2.surrender();
        }
        return true;
    }

    private final boolean split(Player player, HandPlayer handPlayer) {
        if (!handPlayer.isCardFacesSplittableIncludeMessage()) {
            this.dealerMessage = Logz.INSTANCE.getPriorMessage();
            return false;
        }
        this.bankroll.subtract(handPlayer.getWager().getInitialBet());
        HandPlayer splitHand = new HandPlayer(new Wager(handPlayer.getWager()));
        BlackjackCard splitCard = handPlayer.removeSecondCard();
        handPlayer.dealCard(this.deal(true));
        handPlayer.setSplit();
        if (!(!handPlayer.getFirstCard().isAce() || this.config.isResplitAcesAllowed() && handPlayer.getSecondCard().isAce() || this.config.isSplitAcePlayable())) {
            handPlayer.stand();
        }
        splitHand.dealCard(splitCard);
        splitHand.dealCard(this.deal(true));
        splitHand.setSplit();
        splitHand.setAction("p");
        player.getHands().add(splitHand);
        if (!(!splitCard.isAce() || this.config.isResplitAcesAllowed() && splitHand.getSecondCard().isAce() || this.config.isSplitAcePlayable())) {
            splitHand.stand();
        }
        if (handPlayer.getHandValue() == 21) {
            handPlayer.stand();
        }
        if (splitHand.getHandValue() == 21) {
            splitHand.stand();
        }
        return true;
    }

    private final boolean dbl(HandPlayer handPlayer) {
        if (!handPlayer.canDouble(this.config.isDoubleAfterSplitAllowed())) {
            this.dealerMessage = this.msg.getDoubleImpossibleMsg();
            return false;
        }
        handPlayer.dealCard(BlackjackShoe.INSTANCE.deal(true, this.countingSystems));
        handPlayer.stand();
        this.bankroll.subtract(handPlayer.getWager().getInitialBet());
        this.doubleDownWager(handPlayer);
        return true;
    }

    private final void doubleDownWager(HandPlayer handPlayer) {
        handPlayer.getWager().doubleDown();
    }

    private final boolean performAction(Player player, HandPlayer handPlayer, String action) {
        if (handPlayer == null) {
            return false;
        }
        return switch (action) {
            case "u" -> this.surrender(handPlayer);
            case "h" -> {
                this.hit(handPlayer);
                yield true;
            }
            case "d" -> this.dbl(handPlayer);
            case "p" -> this.split(player, handPlayer);
            case "s" -> {
                this.stand(handPlayer);
                yield true;
            }
            default -> false;
        };
    }

    private final boolean isPossibleAction(String action, String ra) {
        if (Intrinsics.areEqual("l", action)) {
            if (!Intrinsics.areEqual("l", ra)) {
                String string = "%s.";
                Object[] objectArray = new Object[]{this.msg.getHandActiveMsg()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                this.dealerMessage = string2;
                return false;
            }
        } else if (Intrinsics.areEqual("l", ra)) {
            String string = "%s L=%s";
            Object[] objectArray = new Object[]{this.msg.getPleaseSelectMsg(), this.msg.getDealMsg()};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            this.dealerMessage = string3;
            return false;
        }
        return true;
    }

    private final void updateMessages(String recommendedActionHeader, String recommendedActionStrategyLine) {
        if (Stringop.INSTANCE.isPopulated(recommendedActionStrategyLine)) {
            this.mistakeHeader = recommendedActionHeader;
            this.mistakeMessage = recommendedActionStrategyLine;
            this.metrics.incrementMistakeCount();
        }
    }

    private final boolean isShuffleNeeded() {
        return BlackjackShoe.INSTANCE.remaining() < BlackjackShoe.INSTANCE.cut();
    }

    public final void setNextBet(int value) {
        this.nextBet = value;
    }

    private final int getWagerIncrement() {
        return this.config.getBetIncrementInWholeDollars() * 100;
    }

    private final void increase() {
        this.setNextBet(this.getNextBet() + this.getWagerIncrement());
        this.updateInactiveHands();
    }

    private final void decrease() {
        this.setNextBet(this.getNextBet() - this.getWagerIncrement());
        this.updateInactiveHands();
    }

    private final void updateInactiveHands() {
        Iterator<Player> iterator2 = this.getCycle().getPlayers().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Player> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Iterator<HandPlayer> iterator4;
            Player player;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(player.getHands().iterator(), "iterator(...)");
            while (iterator4.hasNext()) {
                HandPlayer handPlayer;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (handPlayer.hasCards()) continue;
                this.bankroll.subtract(-handPlayer.getWager().getInitialBet());
                handPlayer.getWager().setInitialBet(this.getNextBet());
                this.bankroll.subtract(handPlayer.getWager().getInitialBet());
            }
        }
    }

    @NotNull
    public final Cycle getCycle() {
        return this.ct.getCycle(this, this.strategy);
    }

    public final boolean isAutomaticRunning() {
        return this.automatic.getName().equals(this.automaticRunningName);
    }

    private final void auto() {
        if (this.isAutomaticRunning()) {
            this.stopAutomaticThread();
        } else if (this.isReadyToRunAutomatically()) {
            this.startAutomaticThread();
        }
    }

    private final void stopAutomaticThread() {
        this.automatic.setName("PanStopRequested");
    }

    private final Thread createNewAutomaticThread() {
        return new Thread(() -> BlackjackGameEngine.createNewAutomaticThread$lambda$0(this));
    }

    private final void startAutomaticThread() {
        if (Intrinsics.areEqual(this.automaticRunningName, this.automatic.getName())) {
            return;
        }
        this.automatic = this.createNewAutomaticThread();
        this.automatic.setName(this.automaticRunningName);
        this.automatic.start();
    }

    private final void doAutomatic() {
        while (this.isAutomaticRunning() && Zombie.INSTANCE.isActive()) {
            int targetStake;
            String ra = this.getCycle().getRecommendedAction();
            if (Intrinsics.areEqual("l", ra) && (targetStake = this.config.getTargetStakeInWholeDollars() * 100) > 0 && this.bankroll.getStakeOutOfPlay() >= (long)targetStake) {
                Logz.INSTANCE.green("Target stake of " + Stringop.INSTANCE.getDollarString(targetStake) + " reached, automatic execution ended.");
                this.stopAutomaticThread();
                return;
            }
            this.exec(ra);
        }
    }

    private final boolean isReadyToRunAutomatically() {
        if (this.isAutomaticRunning()) {
            return false;
        }
        if (this.config.isBasicStrategyVariationsOnly()) {
            String message = "Please turn off \"Variations\" in the Configuration->Rules tab before running automatically.";
            Logz.INSTANCE.warn(message);
            this.dealerMessage = message;
            return false;
        }
        return true;
    }

    public final void shuffle() {
        BlackjackShoe.INSTANCE.shuffle();
        this.countingSystems.resetCount();
        this.dealerMessage = BlackjackShoe.INSTANCE.isTheDeckStacked() ? "Shuffled and stacked deck for debugging" : this.msg.getShuffledMsg();
    }

    private final int getMinBet() {
        return 100 * this.config.getMinimumBetInWholeDollars();
    }

    public final int getNextBet() {
        if (this.nextBet == 0) {
            this.nextBet = this.getMinBet();
        }
        return this.nextBet;
    }

    private final void resetNextBet() {
        this.nextBet = this.getMinBet();
    }

    @NotNull
    public final String getMistakeMessage() {
        return this.mistakeMessage;
    }

    public final void setMistakeMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.mistakeMessage = string;
    }

    @NotNull
    public final String getMistakeHeader() {
        return this.mistakeHeader;
    }

    public final void setMistakeHeader(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.mistakeHeader = string;
    }

    @NotNull
    public final String getDealerMessage() {
        return this.dealerMessage;
    }

    public final void setDealerMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.dealerMessage = string;
    }

    private final void clearMessages() {
        this.mistakeHeader = "";
        this.mistakeMessage = "";
        this.dealerMessage = "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getGameStatusVertical() {
        List rtn2 = new ArrayList();
        StringTokenizer st = new StringTokenizer(this.getGameStatus(), "|");
        while (st.hasMoreElements()) {
            void $this$trim$iv;
            Intrinsics.checkNotNullExpressionValue(st.nextToken(), "nextToken(...)");
            List list = rtn2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            list.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        return rtn2;
    }

    @NotNull
    public final String getGameStatusHorizontal() {
        return StringsKt.replace$default(this.getGameStatus(), "|", "", false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStatusChipsVertical() {
        List rtn2 = new ArrayList();
        StringTokenizer st = new StringTokenizer(this.getRawStatusChips(), "|");
        while (st.hasMoreElements()) {
            void $this$trim$iv;
            Intrinsics.checkNotNullExpressionValue(st.nextToken(), "nextToken(...)");
            List list = rtn2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            list.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        return rtn2;
    }

    @NotNull
    public final String getStatusChipsHorizontal() {
        return StringsKt.replace$default(this.getRawStatusChips(), "|", "", false, 4, null);
    }

    @NotNull
    public final String getGameStatus() {
        StringWriter sw = new StringWriter();
        sw.append("| Stake: " + Stringop.INSTANCE.getDollarString(this.bankroll.getStakeIncludingHands((List<Player>)this.getCycle().getPlayers())));
        sw.append("| Chips: " + Stringop.INSTANCE.getDollarString(this.bankroll.getChips()));
        sw.append("| Score: " + this.metrics.getHandsSinceLastMistake());
        sw.append(" (" + this.metrics.getHandsSinceLastMistakeRecord() + ")");
        if (this.config.isShowCount()) {
            sw.append("| ");
            sw.append(this.countingSystems.findSelected().getName());
            sw.append(": " + this.countingSystems.findSelected().getCount());
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String getRawStatusChips() {
        StringWriter sw = new StringWriter();
        sw.append("  reloads: " + this.bankroll.getReloadCount());
        sw.append("|  Chips: " + Stringop.INSTANCE.getDollarString(this.bankroll.getChips()));
        sw.append("|  Next bet: " + Stringop.INSTANCE.getDollarString(this.getNextBet()));
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final void reportNewHand() {
        if (this.isAutomaticRunning()) {
            this.metrics.reportNewHandAutomatic();
        } else {
            this.metrics.reportNewHand();
        }
    }

    public final boolean isShuffleFlagOn() {
        return this.isShuffleFlagOn;
    }

    public final void triggerShuffleBeforeNextHand() {
        this.isShuffleFlagOn = true;
    }

    public final boolean isBustedPriorHand() {
        return this.isBustedPriorHand;
    }

    public final void setPriorHandBustedFlag() {
        this.isBustedPriorHand = true;
    }

    public final void clearPriorHandBustedFlag() {
        this.isBustedPriorHand = false;
    }

    public final int getStreak() {
        return this.streak;
    }

    public final void incrementStreak() {
        int n = this.streak;
        this.streak = n + 1;
    }

    public final void resetStreak() {
        this.streak = 0;
    }

    public final long getTotalValue() {
        Cycle cycle = this.ct.getCycle();
        return this.bankroll.getStakeIncludingHands((List<Player>)(cycle != null ? cycle.getPlayers() : null));
    }

    public final void setAutomaticOnForTesting() {
        this.startAutomaticThread();
    }

    public final void clearAutomaticForTesting() {
        this.stopAutomaticThread();
    }

    public final void waitMillis(long i) {
        Thread.sleep(i);
    }

    public final boolean isCountVeryNegative() {
        return this.countingSystems.getTrueCount() < this.config.getStrategicVeryNegativeCount();
    }

    public final boolean isCountVeryPositive() {
        return this.countingSystems.getTrueCount() > this.config.getStrategicVeryPositiveCount();
    }

    @NotNull
    public final CycleSnapshot getCurrentSnapshot() {
        return this.lastActionSnapshot;
    }

    private final void getNewActionCycleSnapshot(String action) {
        this.lastActionSnapshot = new CycleSnapshot(this.cloneState(action));
    }

    @NotNull
    public final CycleSnapshot getLastActionSnapshot() {
        return this.lastActionSnapshot;
    }

    public final void setLastActionSnapshot(@NotNull CycleSnapshot cycleSnapshot) {
        Intrinsics.checkNotNullParameter(cycleSnapshot, "<set-?>");
        this.lastActionSnapshot = cycleSnapshot;
    }

    private static final void createNewAutomaticThread$lambda$0(BlackjackGameEngine this$0) {
        this$0.doAutomatic();
    }
}

